<div class="page-title">
    <div class="breadcrumb-env">
        <ul class="user-info-menu left-links list-inline list-unstyled">
            <li class="hidden-sm hidden-xs">
                <a href="#" data-toggle="sidebar">
                    <i class="fa-bars"></i>
                </a>
            </li>
        </ul>
        <ol class="breadcrumb bc-1" >
            <li>
                <a href="<?php echo site_url('admin/dashboard') ?>"><i class="fa-home"></i><?php echo lang('global_home') ?></a>
            </li>
            <li class="active">
                <strong><?php echo lang('global_blog') ?></strong>
            </li>
        </ol>

    </div>

</div>
<!-- Admin Table-->
<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title"><?php echo lang('global_blog') ?></h3>
    </div>
    <div class="panel-body">
        <?php if (validation_errors()) : ?>
            <div class="col-md-12">
                <div class="alert alert-danger">
                    <?php echo validation_errors() ?>
                </div>
            </div>
        <?php endif ?>
        <form role="form" class="form-horizontal" role="form" method="post" enctype="multipart/form-data">
            <div class="form-group">
                <label class="col-sm-2 control-label"><?php echo lang('display_article') ?> <span class="required">*</span> </label>
                <div class="col-sm-10">
                    <p>
                        <label class="radio-inline">
                            <input type="radio" value="1" name="display"
                                   <?php if (set_value('display', $item->display) == '1'): ?>checked="checked"<?php endif; ?>>
                                   <?php echo lang('global_yes') ?>
                        </label>
                        <label class="radio-inline">
                            <input type="radio" value="0" name="display"
                                   <?php if (set_value('display', $item->display) == '0'): ?>checked="checked"<?php endif; ?>>  
                                   <?php echo lang('global_no') ?>
                        </label>
                    </p>
                </div>
            </div>
            <div class="form-group-separator"></div>
            <div class="form-group">
                <label class="col-sm-2 control-label" for="field-1"><?php echo lang('global_author') ?> <span class="required">*</span> </label>

                <div class="col-sm-10">
                    <input type="text" class="form-control" placeholder="<?php echo lang('global_author') ?>" name="author"
                           value="<?php echo set_value('author', $item->author) ?>">
                </div>
            </div>
            <div class="form-group-separator"></div>
            <div class="form-group">
                <label class="col-sm-2 control-label"><?php echo lang('global_category') ?></label>

                <div class="col-sm-10">
                    <?php echo form_dropdown('blog_category_id', dd2menu('blog_categories', array('blog_category_id' => 'title')), set_value('blog_category_id', $item->blog_category_id), 'class="form-control"') ?>
                </div>
            </div>
            <div class="form-group-separator"></div>

            <div class="form-group">
                <label class="col-sm-2 control-label" for="field-1"><?php echo lang('global_title') ?> <span class="required">*</span> </label>

                <div class="col-sm-10">
                    <input type="text" class="form-control" placeholder="<?php echo lang('global_title') ?>" name="title"
                           value="<?php echo set_value('title', $item->title) ?>">
                </div>
            </div>
            <div class="form-group-separator"></div>

            <div class="form-group">
                <label class="col-sm-2 control-label" for="field-1"><?php echo lang('global_short_description') ?> <span class="required">*</span></label>

                <div class="col-sm-10">
                    <textarea class="form-control" placeholder="<?php echo lang('global_short_description') ?>" name="short_description"><?php echo set_value('short_description', $item->short_description) ?></textarea>
                </div>
            </div>
            <div class="form-group-separator"></div>
            <div class="form-group">
                <label class="col-sm-2 control-label" for="field-1"><?php echo lang('global_description') ?> <span class="required">*</span></label>

                <div class="col-sm-10">
                    <textarea class="form-control" placeholder="<?php echo lang('global_description') ?>" name="description"><?php echo set_value('description', $item->description) ?></textarea>
                </div>
            </div>
            <div class="form-group-separator"></div>


            <div class="form-group">
                <label class="col-sm-2 control-label" for="field-1"> <?php echo lang('global_featured_image') ?> <span class="required">*</span></label>

                <div class="col-sm-8">
                    <input class="form-control" type="file" name="image" >
                </div>
                <div class="col-sm-2">
                    <?php if ($item->image): ?>
                        <img src="<?php echo base_url() ?>cdn/blog/<?php echo $item->image ?>" class="img-inline userpic-32" width="40"/>
                    <?php endif ?>
                </div>
            </div>
            <div class="form-group-separator"></div>

            <div class="form-group">
                <label class="col-sm-2 control-label" for="field-1"><?php echo lang('global_tags') ?></label>

                <div class="col-sm-10">
                    <textarea class="form-control" placeholder="<?php echo lang('global_tags') ?>" name="meta_keywords"><?php echo set_value('meta_keywords', $item->meta_keywords) ?></textarea>
                </div>
            </div>
            <div class="form-group-separator"></div>
            <div class="form-group">
                <label class="col-sm-2 control-label" for="field-1"><?php echo lang('settings_meta_description') ?></label>
                <div class="col-sm-10">
                    <textarea class="form-control" placeholder="<?php echo lang('settings_meta_description') ?>" name="meta_description"><?php echo set_value('meta_description', $item->meta_description) ?></textarea>
                </div>
            </div>
            <div class="form-group-separator"></div>
            <div class="form-group">
                <label class="col-sm-2 control-label"></label>
                <div class="col-sm-10">
                    <input type="submit" class="btn btn-secondary " name="submit" value="<?php echo lang('global_submit') ?>">
                    <a href="<?php echo site_url('admin/blog'); ?>" class="btn btn-danger"><?php echo lang('global_cancel') ?></a>
                </div>
            </div>
        </form>
    </div>
</div>

<script src="<?php echo STYLE_JS ?>/ckeditor/ckeditor.js" type="text/javascript"></script>
<script>
    $(document).ready(function () {
        CKEDITOR.replace('description', {
<?php if (config('direction') == 'ltr'): ?>
            contentsLangDirection: 'ltr'
<?php else: ?>
            contentsLangDirection: 'rtl'
<?php endif ?>
    });
    });
</script>
